/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import PETER_Monitor.vital_monitor.settings_monitor.CreateAboutPanel;
import PETER_Monitor.vital_monitor.settings_monitor.CreateBoundariesPanel;
import PETER_Monitor.vital_monitor.settings_monitor.CreateGeneralPanel;
import PETER_Monitor.vital_monitor.settings_monitor.CreateSoundPanel;
import PETER_Monitor.vital_monitor.settings_monitor.WriteSettings;
import PETER_Monitor.vital_values.SimpleVitalFunction;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;

public class Settings {
    private Alert options;
    private ArrayList<SimpleVitalFunction> vitalFunctions;
    private GridPane pane;
    private GridPane activeContent;
    private ListView menuList;
    private Button applyButton;
    public static final int GENERIC_INDEX = 0;
    public static final int SOUND_INDEX = 2;
    public static final int VITAL_BOUNDARIES_INDEX = 1;
    public static final int ABOUT_INDEX = 3;
    private Button defibrilatorMute;
    private Button nibpMute;
    private CreateSoundPanel soundPanel;
    private CreateGeneralPanel generalPanel;

    public Settings(Button button, Button button2) {
        this.defibrilatorMute = button;
        this.nibpMute = button2;
    }

    public void setVitalFunctions(ArrayList<SimpleVitalFunction> arrayList) {
        this.vitalFunctions = arrayList;
    }

    public void showSettings(int n) {
        ButtonType buttonType = new ButtonType("Ulo\u017eit", ButtonType.APPLY.getButtonData());
        ButtonType buttonType2 = new ButtonType("Ok", ButtonType.OK.getButtonData());
        ButtonType buttonType3 = new ButtonType("Cancel", ButtonType.CANCEL.getButtonData());
        this.options = new Alert(Alert.AlertType.CONFIRMATION);
        this.options.getButtonTypes().set(0, (Object)buttonType2);
        this.options.getButtonTypes().set(1, (Object)buttonType);
        this.options.getButtonTypes().add(2, (Object)buttonType3);
        this.options.setTitle("Nastaven\u00ed");
        this.options.setHeaderText(" ");
        DialogPane dialogPane = this.options.getDialogPane();
        dialogPane.getStylesheets().add((Object)this.getClass().getResource("../monitorCSS.css").toExternalForm());
        this.applyButton = (Button)this.options.getDialogPane().lookupButton(buttonType);
        this.applyButton.setDisable(true);
        this.applyButton.addEventFilter(ActionEvent.ACTION, actionEvent -> {
            this.saveChanges();
            this.applyButton.setDisable(true);
            actionEvent.consume();
        });
        this.options.setGraphic((Node)this.createSettingPanel());
        this.menuList.getSelectionModel().select(n);
        Button button = (Button)this.options.getDialogPane().lookupButton(buttonType2);
        button.addEventFilter(ActionEvent.ACTION, actionEvent -> {
            if (!this.applyButton.isDisable()) {
                this.saveChanges();
            }
        });
        this.options.showAndWait();
    }

    private GridPane createSettingPanel() {
        this.pane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints(100.0, 100.0, 100.0);
        ColumnConstraints columnConstraints2 = new ColumnConstraints(400.0, 450.0, 450.0);
        this.pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2});
        RowConstraints rowConstraints = new RowConstraints(300.0, 300.0, 300.0);
        Separator separator = new Separator(Orientation.VERTICAL);
        this.pane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints});
        this.pane.add((Node)this.createMenuPanel(), 0, 0);
        this.pane.add((Node)separator, 1, 0);
        return this.pane;
    }

    private VBox createMenuPanel() {
        VBox vBox = new VBox();
        this.menuList = new ListView(FXCollections.observableArrayList((Object[])new String[]{"Obecn\u00e9", "Nastaven\u00ed mez\u00ed", "Zvuk", "O aplikaci"}));
        this.menuList.setMinHeight(100.0);
        this.menuList.setMaxHeight(100.0);
        this.menuList.getStyleClass().add((Object)"settings");
        this.menuList.getSelectionModel().selectedItemProperty().addListener((observableValue, object, object2) -> {
            if (object != null && object.equals(object2)) {
                return;
            }
            this.displaySelectedMenuContent(this.menuList.getSelectionModel().getSelectedIndex());
        });
        Label label = new Label("Nastaven\u00ed");
        vBox.getChildren().addAll((Object[])new Node[]{label, this.menuList});
        return vBox;
    }

    private void displaySelectedMenuContent(int n) {
        this.pane.getChildren().remove((Object)this.activeContent);
        switch (n) {
            case 0: {
                this.generalPanel = new CreateGeneralPanel();
                this.activeContent = this.generalPanel.createGeneralPanel(this.applyButton);
                break;
            }
            case 1: {
                CreateBoundariesPanel createBoundariesPanel = new CreateBoundariesPanel();
                this.activeContent = createBoundariesPanel.createChangeFunctionsBounderiesPanel(this.applyButton);
                break;
            }
            case 2: {
                this.soundPanel = new CreateSoundPanel();
                this.activeContent = this.soundPanel.createSoundSettingsPanel(this.applyButton);
                break;
            }
            case 3: {
                CreateAboutPanel createAboutPanel = new CreateAboutPanel();
                this.activeContent = createAboutPanel.createAboutPanel(true);
            }
        }
        this.pane.add((Node)this.activeContent, 1, 0);
        this.applyButton.setDisable(true);
    }

    private void saveChanges() {
        switch (this.menuList.getSelectionModel().getSelectedIndex()) {
            case 0: {
                this.generalPanel.saveGeneralChanges();
                break;
            }
            case 1: {
                CreateBoundariesPanel createBoundariesPanel = new CreateBoundariesPanel();
                createBoundariesPanel.saveBoundariesChanges(this.pane, this.vitalFunctions);
                this.displaySelectedMenuContent(1);
                break;
            }
            case 2: {
                this.soundPanel.saveSoundChanges(this.defibrilatorMute, this.nibpMute);
            }
        }
        WriteSettings.writeSettings();
    }
}

