/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Remoter.remoter_GUI.Alerts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class WriteSettings {
    public static void writeSettings() {
        WriteSettings.createFolder("data");
        WriteSettings.createFolder("data/settings");
        File file = new File("data/settings/settings.cfg");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            WriteSettings.writeLanguage(bufferedWriter);
            WriteSettings.writeBoundaries(bufferedWriter);
            WriteSettings.writeSound(bufferedWriter);
            WriteSettings.writeWarningColor(bufferedWriter);
        }
        catch (Exception exception) {
            Alerts.warningAlert("Chyba p\u0159i ukl\u00e1d\u00e1n\u00ed", "Chyba v nastaven\u00ed", "Nebylo mo\u017en\u00e9 ulo\u017eit va\u0161e nastaven\u00ed. Bylo na\u010dteno zp\u011bt defaultn\u00ed.");
        }
    }

    private static void createFolder(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static void writeLanguage(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("language=" + SettingsValues.locale);
        bufferedWriter.newLine();
    }

    private static void writeSound(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("muteAll=" + SettingsValues.ALLSounds);
        bufferedWriter.newLine();
        bufferedWriter.write("muteDefibrillator=" + SettingsValues.DEFIBRILATORSound);
        bufferedWriter.newLine();
        bufferedWriter.write("muteNIBP=" + SettingsValues.NIBPSound);
        bufferedWriter.newLine();
        bufferedWriter.write("muteECG=" + SettingsValues.ECGSound);
        bufferedWriter.newLine();
    }

    private static void writeBoundaries(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("HRmin=" + SettingsValues.HRmin.get());
        bufferedWriter.newLine();
        bufferedWriter.write("HRmax=" + SettingsValues.HRmax.get());
        bufferedWriter.newLine();
        bufferedWriter.write("HRcolor=" + SettingsValues.HRcolor.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("Spo2min=" + SettingsValues.SPO2min.get());
        bufferedWriter.newLine();
        bufferedWriter.write("Spo2max=" + SettingsValues.SPO2max.get());
        bufferedWriter.newLine();
        bufferedWriter.write("Spo2color=" + SettingsValues.SPO2color.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("PPmin=" + SettingsValues.PPmax.get());
        bufferedWriter.newLine();
        bufferedWriter.write("PPmax=" + SettingsValues.PPmax.get());
        bufferedWriter.newLine();
        bufferedWriter.write("PPcolor=" + SettingsValues.PPcolor.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("NIBPcolor=" + SettingsValues.NIBPcolor.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("ETCO2min=" + SettingsValues.ETCO2min.get());
        bufferedWriter.newLine();
        bufferedWriter.write("ETCO2max=" + SettingsValues.ETCO2max.get());
        bufferedWriter.newLine();
        bufferedWriter.write("ETCO2color=" + SettingsValues.ETCO2color.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("Tempmin=" + SettingsValues.TEMPmin.get());
        bufferedWriter.newLine();
        bufferedWriter.write("Tempmax=" + SettingsValues.TEMPmax.get());
        bufferedWriter.newLine();
        bufferedWriter.write("Tempcolor=" + SettingsValues.TEMPcolor.toString());
        bufferedWriter.newLine();
    }

    private static void writeWarningColor(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("TOPwarning=" + SettingsValues.TOPwarning.toString());
        bufferedWriter.newLine();
        bufferedWriter.write("BOTTOMwarning=" + SettingsValues.BOTTOMwarning.toString());
        bufferedWriter.newLine();
    }
}

