/*
 * Decompiled with CFR 0.152.
 */
package PETER_Communications.com_protocol;

import PETER_Communications.com_protocol.VitalData;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client
extends Thread {
    private boolean closeServer = false;
    private boolean closeClient = false;
    private Socket clientSocket;
    private int usingPort = 55560;

    @Override
    public void run() {
        String ip = null;
        while (ip == null) {
            if (!this.closeClient) {
                this.usingPort = 55555;
                ip = this.getServerIp(this.sendSocketToBroadcasts());
                continue;
            }
            return;
        }
        this.closeServer = false;
        this.clientConnection(ip);
        System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    public VitalData recieveData() {
        VitalData data = null;
        try {
            if (this.clientSocket == null) {
                this.closeClient();
                return null;
            }
            data = this.readData(this.clientSocket.getInputStream());
            if (data == null) {
                this.closeServer = true;
                return null;
            }
        }
        catch (SocketException ex) {
            this.closeClient();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return data;
    }

    private boolean clientConnection(String ip) {
        try {
            InetSocketAddress addr = new InetSocketAddress(ip, this.usingPort);
            this.clientSocket = new Socket();
            this.clientSocket.connect(addr);
            return true;
        }
        catch (IOException ex) {
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
            return false;
        }
    }

    private VitalData readData(InputStream is) throws SocketException, IOException {
        VitalData data = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            data = (VitalData)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return data;
    }

    private String getServerIp(DatagramSocket socket) {
        try {
            byte[] recvBuf = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
            socket.setSoTimeout(3000);
            try {
                socket.receive(receivePacket);
            }
            catch (SocketTimeoutException ex) {
                return null;
            }
            this.usingPort = receivePacket.getPort();
            return receivePacket.getAddress().getHostAddress();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private DatagramSocket sendSocketToBroadcasts() {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            while (this.usingPort < 55560) {
                socket.setBroadcast(true);
                byte[] sendData = "CONNECTION_VERIFICATION".getBytes();
                try {
                    DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName("255.255.255.255"), this.usingPort);
                    socket.send(sendPacket);
                }
                catch (Exception sendPacket) {
                    // empty catch block
                }
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    InetAddress broadcast = null;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        broadcast = interfaceAddress.getBroadcast();
                        if (broadcast != null) continue;
                    }
                    try {
                        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, broadcast, this.usingPort);
                        socket.send(sendPacket);
                    }
                    catch (Exception exception) {}
                }
                ++this.usingPort;
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return socket;
    }

    public void closeClient() {
        this.closeClient = true;
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean isCloseServer() {
        return this.closeServer;
    }

    public void setCloseServer(boolean closeServer) {
        this.closeServer = closeServer;
    }

    public boolean isCloseClient() {
        return this.closeClient;
    }

    public void setCloseClient(boolean closeClient) {
        this.closeClient = closeClient;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    static {
        System.setProperty("log4j.configurationFile", "PETER_Communications/com_protocol/client_configuration.xml");
    }
}

