/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_monitor.PlaySounds;
import PETER_Monitor.vital_monitor.settings_monitor.ValuesAboutStateOfAplication;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;

public class DefibrilatorHandle {
    private Timeline reloading;
    private Timeline countingTimeLast;
    private Timeline countingTimeTotal;
    private Timeline analyseAnimation;
    private GridPane defibrilator;
    private Label typeOfDefibrilator;
    private Label power;
    private Label numberOfShocksLabel;
    private Label timeLastLabel;
    private Label timeTotalLabel;
    private Label infoLabel;
    private ProgressBar reload;
    private ProgressBar analyse;
    private Button shock;
    private Button power50;
    private Button power100;
    private Button power150;
    private Button power200;
    private Button lowImpedance;
    private Button mediumImpedance;
    private Button highImpedance;
    private Button closeDefibrilator;
    private int numberOfShocks;
    private int timeLast;
    private int timeTotal;
    private double powerValue;
    private boolean startOfDef;
    private boolean isAED;
    private boolean analysaResult;
    private boolean isAnalysaComplete;
    private boolean terapyElectrods;
    private boolean electrods;
    private int impedance;
    private PlaySounds playSounds;
    private boolean activeSounds;
    private int defaultVolumeSound = 5;

    public DefibrilatorHandle(GridPane defibrilator, Label typeOfDefibrilator, Label power, Label numberOfShocksLabel, Label timeLastLabel, Label timeTotalLabel, ProgressBar reload, Button shock, Label infoLabel, ProgressBar analyse, Button closeDefibrilator) {
        this.defibrilator = defibrilator;
        this.typeOfDefibrilator = typeOfDefibrilator;
        this.power = power;
        this.numberOfShocksLabel = numberOfShocksLabel;
        this.timeLastLabel = timeLastLabel;
        this.timeTotalLabel = timeTotalLabel;
        this.reload = reload;
        this.shock = shock;
        this.startOfDef = false;
        this.infoLabel = infoLabel;
        this.analyse = analyse;
        this.playSounds = new PlaySounds(this.defaultVolumeSound);
        this.closeDefibrilator = closeDefibrilator;
        this.terapyElectrods = false;
        this.electrods = false;
        this.activeSounds = true;
    }

    public void setImpedance(int impedance) {
        this.impedance = impedance;
    }

    public void setActiveSounds(boolean isActive) {
        if (!isActive) {
            this.activeSounds = false;
            this.playSounds.setVolume(0);
        } else {
            this.activeSounds = true;
            this.playSounds.setVolume(this.defaultVolumeSound);
        }
    }

    public void setActivePowerButton(Button active, Button energy50, Button energy100, Button energy150, Button energy200) {
        String newStyle = "-fx-background-color:white; -fx-text-fill:black;";
        this.power50 = energy50;
        this.power100 = energy100;
        this.power150 = energy150;
        this.power200 = energy200;
        switch (active.getText()) {
            case "50 J": {
                energy50.setStyle(newStyle);
                energy100.setStyle("");
                energy150.setStyle("");
                energy200.setStyle("");
                this.powerValue = 50.0;
                break;
            }
            case "100 J": {
                energy50.setStyle("");
                energy100.setStyle(newStyle);
                energy150.setStyle("");
                energy200.setStyle("");
                this.powerValue = 100.0;
                break;
            }
            case "150 J": {
                energy50.setStyle("");
                energy100.setStyle("");
                energy150.setStyle(newStyle);
                energy200.setStyle("");
                this.powerValue = 150.0;
                break;
            }
            case "200 J": {
                energy50.setStyle("");
                energy100.setStyle("");
                energy150.setStyle("");
                energy200.setStyle(newStyle);
                this.powerValue = 200.0;
            }
        }
        this.power.setText(active.getText());
    }

    public boolean isActiveSound() {
        return this.activeSounds;
    }

    public void defibStart(String mode, GridPane manualSetting, GridPane AEDfunction) {
        if (mode.equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed"))) {
            this.setModeDefibrilator(true, LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mod.aed"), manualSetting, AEDfunction);
            ValuesAboutStateOfAplication.isDefibrilatorManualOn = false;
            ValuesAboutStateOfAplication.isDefibrilatorAEDOn = true;
            this.changeElectrods();
        } else {
            this.setModeDefibrilator(false, LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mod.manual"), manualSetting, AEDfunction);
            ValuesAboutStateOfAplication.isDefibrilatorAEDOn = false;
            ValuesAboutStateOfAplication.isDefibrilatorManualOn = true;
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
        this.showDefibrilator();
    }

    public void reloadDefibrilator(boolean isManual) {
        if (this.reloading == null && this.startOfDef) {
            this.disablePowerButtons(true);
            double time = this.powerValue / 1000.0 * 2.0;
            if (isManual) {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.charge"));
            }
            this.changeCloseButton(true);
            this.reloading = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)time), e -> this.reloadDefRun(), new KeyValue[0])});
            this.reloading.setCycleCount(-1);
            this.reloading.play();
        }
    }

    public void startShock() {
        Platform.runLater(() -> {
            this.reload.setProgress(0.0);
            this.numberOfShocksLabel.setText(++this.numberOfShocks + "");
            this.timeLast = 0;
            this.timeLastLabel.setText("00:00");
            this.shock.setDisable(true);
            this.disablePowerButtons(false);
            this.disableImpedanceButtons(false);
            this.changeCloseButton(false);
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.shockGiven"));
            this.playSounds.stopShockReadyAnimation();
            this.playSounds.playSound("shock_given.wav");
        });
        if (this.countingTimeLast == null) {
            this.countingTimeLast = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), e -> this.setTimeLast(), new KeyValue[0])});
            this.countingTimeLast.setCycleCount(-1);
            this.countingTimeLast.play();
        }
    }

    public void setElectrods(boolean electrods, boolean terapyElectrods) {
        if (electrods != this.electrods || terapyElectrods != this.terapyElectrods) {
            this.electrods = electrods;
            this.terapyElectrods = terapyElectrods;
            if (this.defibrilator.isVisible()) {
                this.changeElectrods();
            }
        }
    }

    private void setTimeTotal() {
        String time = "";
        int minutes = this.timeTotal / 60;
        int seconds = this.timeTotal % 60;
        time = minutes < 10 ? time + "0" + minutes + ":" : time + minutes + ":";
        time = seconds < 10 ? time + "0" + seconds : time + seconds;
        this.timeTotalLabel.setText(time);
        ++this.timeTotal;
    }

    private void setTimeLast() {
        String time = "";
        int minutes = this.timeLast / 60;
        int seconds = this.timeLast % 60;
        time = minutes < 10 ? time + "0" + minutes + ":" : time + minutes + ":";
        time = seconds < 10 ? time + "0" + seconds : time + seconds;
        if (minutes == 0 && seconds == 1 && !this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
        if (minutes == 0 && seconds == 4 && this.isAED && this.analyseAnimation == null) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.KPR"));
            this.playSounds.playSound("do_kpr.wav");
        }
        if (minutes == 2 && seconds == 0 && this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.startAnalyse"));
            this.playSounds.playSound("start_analyse_ekg.wav");
        }
        this.timeLastLabel.setText(time);
        ++this.timeLast;
    }

    public void showDefibrilator() {
        if (this.countingTimeTotal == null) {
            this.defibrilator.setVisible(true);
            this.startOfDef = true;
            Platform.runLater(() -> {
                this.powerValue = 200.0;
                this.power.setText((int)this.powerValue + " J");
                this.numberOfShocks = 0;
                this.numberOfShocksLabel.setText(this.numberOfShocks + "");
                this.timeLast = 0;
                this.timeLastLabel.setText("00:00");
                this.timeTotal = 1;
                this.timeTotalLabel.setText("00:01");
            });
            this.countingTimeTotal = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), e -> this.setTimeTotal(), new KeyValue[0])});
            this.countingTimeTotal.setCycleCount(-1);
            this.countingTimeTotal.play();
        }
    }

    public void hideDefibrilator() {
        this.defibrilator.setVisible(false);
        this.startOfDef = false;
        this.countingTimeLast = this.stopAnimation(this.countingTimeLast);
        this.countingTimeTotal = this.stopAnimation(this.countingTimeTotal);
    }

    public void changeElectrods() {
        if (!this.setElectrodsAction()) {
            return;
        }
        if (!this.changeTerapyElectrods()) {
            return;
        }
        if (this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.startAnalyse"));
            this.playSounds.playSound("start_analyse_ekg.wav");
        } else {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
    }

    private boolean changeTerapyElectrods() {
        if (!this.terapyElectrods) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.freeTherapyElektrode"));
            this.playSounds.playSound("connect_electrods_for_terapy.wav");
            return false;
        }
        return true;
    }

    public void runAnalyza(boolean result) {
        if (!(this.electrods && this.terapyElectrods && this.isAED && this.analyseAnimation == null)) {
            return;
        }
        this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontTouch"));
        this.playSounds.playSound("dont_touch_pacient.wav");
        this.isAnalysaComplete = false;
        this.analysaResult = result;
        this.changeCloseButton(true);
        this.analyseAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), e -> this.analyseAnimation(), new KeyValue[0])});
        this.analyseAnimation.setCycleCount(-1);
        this.analyseAnimation.play();
    }

    public void setImpedanceFromRemoter(int impedance, Button low, Button medium, Button high) {
        String newStyle = "-fx-background-color:white; -fx-text-fill:black;";
        this.lowImpedance = low;
        this.mediumImpedance = medium;
        this.highImpedance = high;
        switch (impedance) {
            case 0: {
                low.setStyle(newStyle);
                high.setStyle("");
                medium.setStyle("");
                break;
            }
            case 1: {
                medium.setStyle(newStyle);
                low.setStyle("");
                high.setStyle("");
                break;
            }
            case 2: {
                high.setStyle(newStyle);
                medium.setStyle("");
                low.setStyle("");
            }
        }
        this.setImpedance(impedance);
    }

    private void disablePowerButtons(boolean disable) {
        this.power50.setDisable(disable);
        this.power100.setDisable(disable);
        this.power150.setDisable(disable);
        this.power200.setDisable(disable);
    }

    private void disableImpedanceButtons(boolean disable) {
        this.lowImpedance.setDisable(disable);
        this.mediumImpedance.setDisable(disable);
        this.highImpedance.setDisable(disable);
    }

    private void changeCloseButton(boolean isClose) {
        if (isClose) {
            this.closeDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("global.cancel"));
            this.closeDefibrilator.setOnAction(event -> this.cancelReloading());
        } else {
            this.closeDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("global.close"));
            this.closeDefibrilator.setOnAction(event -> this.hideDefibrilator());
        }
    }

    private void cancelReloading() {
        this.analyseAnimation = this.stopAnimation(this.analyseAnimation);
        this.reloading = this.stopAnimation(this.reloading);
        this.analyse.setProgress(0.0);
        this.reload.setProgress(0.0);
        this.disableImpedanceButtons(false);
        this.disablePowerButtons(false);
        this.changeCloseButton(false);
        this.shock.setDisable(true);
        this.playSounds.stopShockReadyAnimation();
        if (this.isAED) {
            this.changeElectrods();
        } else {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
    }

    private Timeline stopAnimation(Timeline tl) {
        if (tl != null) {
            tl.stop();
        }
        return null;
    }

    private void setModeDefibrilator(boolean isAED, String mode, GridPane manualSetting, GridPane AEDfunction) {
        this.typeOfDefibrilator.setText(mode);
        this.isAED = isAED;
        manualSetting.setVisible(!isAED);
        AEDfunction.setVisible(isAED);
    }

    private void analyseAnimation() {
        double progress = this.analyse.getProgress();
        this.analyse.setProgress(progress + 0.07);
        if (progress > 0.25 && this.analysaResult) {
            this.reloadDefibrilator(false);
        }
        if ((int)progress == 1 && !this.analysaResult) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontShock"));
            this.playSounds.playSound("dont_give_shock.wav");
        }
        if ((int)progress == 1) {
            this.analyse.setProgress(0.0);
            this.analyseAnimation = this.stopAnimation(this.analyseAnimation);
            this.isAnalysaComplete = true;
        }
    }

    private boolean setElectrodsAction() {
        if (!this.electrods) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.freeECGElektrode"));
            this.playSounds.playSound("free_ekg_electrod.wav");
            return false;
        }
        return true;
    }

    private void reloadDefRun() {
        if ((int)this.reload.getProgress() < 1) {
            this.reload.setProgress(this.reload.getProgress() + 0.05);
            return;
        }
        if (!this.handleShockReady()) {
            return;
        }
        this.chargeWithAnalyse();
    }

    private boolean handleShockReady() {
        if (this.impedance != 1) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.wrongImpedance"));
            return false;
        }
        this.reloading = this.stopAnimation(this.reloading);
        this.disableImpedanceButtons(true);
        this.shock.setDisable(false);
        if (!this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.shockReady"));
            this.playSounds.playSound("give_shock.wav");
            this.playSounds.startShockReadyAnimation();
            return false;
        }
        return true;
    }

    private void chargeWithAnalyse() {
        if ((int)this.reload.getProgress() == 1 && this.isAnalysaComplete) {
            if (this.analysaResult) {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.giveShock"));
                this.playSounds.playSound("give_shock.wav");
                this.playSounds.startShockReadyAnimation();
            } else {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontShock"));
                this.playSounds.playSound("dont_give_shock.wav");
            }
        }
    }

    public void pauseAnimations() {
        if (this.reloading != null) {
            this.reloading.pause();
        }
        if (this.playSounds != null) {
            this.playSounds.stopSound();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.pause();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.pause();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.pause();
        }
        this.playSounds.stopShockReadyAnimation();
    }

    public void resumeAnimation() {
        if (this.reloading != null) {
            this.reloading.play();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.play();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.play();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.play();
        }
    }

    public void clear() {
        if (this.reloading != null) {
            this.reloading.stop();
        }
        if (this.playSounds != null) {
            this.playSounds.stopSound();
            this.playSounds.stopShockReadyAnimation();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.stop();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.stop();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.stop();
        }
        this.reloading = null;
        this.playSounds = null;
        this.countingTimeLast = null;
        this.countingTimeTotal = null;
        this.analyseAnimation = null;
    }
}

