/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_values;

import PETER_Monitor.vital_values.SimpleVitalFunction;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;

public class NIBPVitalFunction
extends SimpleVitalFunction {
    private Label mapPressureLabel;
    private Label diaAndSysPressureLabel;

    public NIBPVitalFunction(String nameShortcut, String unitsShortcut, Color colorOfFont) {
        super(nameShortcut, unitsShortcut, colorOfFont, 0, 0);
        this.changeComplete = true;
    }

    @Override
    protected void prepareLabels() {
        this.unitsShortcutLabel = new Label(this.unitsShortcut);
        this.nameShortcutLabel = new Label(this.nameShortcut);
        this.diaAndSysPressureLabel = new Label("---/---");
        this.mapPressureLabel = new Label("(---)");
        this.unitsShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.nameShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.diaAndSysPressureLabel.setAlignment(Pos.CENTER);
        this.mapPressureLabel.setAlignment(Pos.CENTER);
        this.diaAndSysPressureLabel.setStyle("-fx-font-size:25;");
        this.mapPressureLabel.setStyle("-fx-font-size:20;");
        this.diaAndSysPressureLabel.setPadding(new Insets(0.0, 0.0, 30.0, 0.0));
        this.mapPressureLabel.setPadding(new Insets(30.0, 0.0, 0.0, 0.0));
        this.unitsShortcutLabel.textFillProperty().bind((ObservableValue)this.colorOfFont);
        this.nameShortcutLabel.textFillProperty().bind((ObservableValue)this.colorOfFont);
        this.diaAndSysPressureLabel.textFillProperty().bind((ObservableValue)this.colorOfFont);
        this.mapPressureLabel.textFillProperty().bind((ObservableValue)this.colorOfFont);
    }

    @Override
    protected void fillGridpane() {
        this.prepareLabels();
        this.panel.add((Node)this.background, 0, 0, 3, 3);
        this.panel.add((Node)this.nameShortcutLabel, 0, 0, 1, 1);
        this.panel.add((Node)this.unitsShortcutLabel, 0, 2, 1, 1);
        this.panel.add((Node)this.diaAndSysPressureLabel, 1, 1, 1, 1);
        this.panel.add((Node)this.mapPressureLabel, 1, 1, 1, 1);
    }

    public void setDiaAndSysPressure(int diaPressure, int sysPressure) {
        this.diaAndSysPressureLabel.setText(sysPressure + "/" + diaPressure);
    }

    public void setMapPressure(int mapPressure) {
        this.mapPressureLabel.setText("(" + mapPressure + ")");
    }

    @Override
    public void verifyHealthBorders() {
    }

    @Override
    public void setDefaultView() {
    }

    @Override
    public void setDeadState() {
    }
}

