package data;

import java.net.URL;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.media.AudioClip;

/**
 * Knihovni trida.... TODO
 *
 * @author Patrik Patera
 * @version 1.00
 */
public class ECGConst {

    private ECGConst() {
    }

    /**
     * Jak dlouho bude trvat vykreslovani ECG krivky.
     */
    public static final float DURATION_SECONDS = 5.0f;

    /**
     * Prevod casu ze sekundy na nanosekundy.
     */
    public static final double SEC_TO_NANOSEC = 1e9;

    /**
     * Touto hodnotou prenasobujeme pocet komplexu ya DURATION_SECOND k zjisteni
     * kolik je BPM.
     */
    public static final double COUNT_COMPLEX_IN_MINUTE = 6 * (10.0 / DURATION_SECONDS);

    /**
     * Vykreslovaci frekvence bodu pri CO2.
     */
    public static final float CO2_VZOREK = .02f;

    /**
     * Maximalni pocet bodu vykreslovanych v CO2 grafu.
     */
    public static final int MAX_C02_POINTS = (int) (DURATION_SECONDS / CO2_VZOREK);

    /**
     * Minimalni X-ova hodnota grafu.
     */
    public static final int XAXIS_MIN = 0;

    /**
     * Maximalni X-ova hodnota grafu.
     */
    public static final int XAXIS_MAX = 5;

    /**
     * Maximalni pocet prvku ve fronte.
     */
    public static final int MAX_COUNT_QUEUE = 200;

    /**
     * Velikost intervalu, ktery odstranuje data (delka).
     */
    public static final float REMOVE_LENGTH = 0.22f;

    /**
     * Standartni hodnota pro Y ECG1 - aby ve vykreslovani nenastal skok.
     * Funguje pouze pro dodane vzorky.
     */
    public static final float Y_ECG1_VALUE = 0.148f;

    /**
     * Standartni hodnota pro Y ECG2 - aby ve vykreslovani nenastal skok.
     * Funguje pouze pro dodane vzorky.
     */
    public static final float Y_ECG2_VALUE = 0.175f;

    /**
     * Cesta ke zvuku pipnuti.
     */
    public static final URL RESOURCE_BEEP = ECGConst.class.getResource("beep.wav");

    /**
     * Otevreni zvuku pipnuti jako AudioClip nad kterym je mozno spustit play.
     */
    public static final AudioClip BEEP = new AudioClip(RESOURCE_BEEP.toString());

}
