package data;


import javafx.util.Pair;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.*;

public class ECGUtils {

    /**
     * Path to the configuration with ECG curves.
     */
    private static final String ECG_CURVE_PROP_PATH = "data/configures/ecg_curves.properties";

    /**
     * Name of property with ECG curves metadata.
     */
    private static final String ECG_CURVES_PROP = "ecg.metadata.curves";

    private static final Properties ecgProp = Utils.loadProperties(ECG_CURVE_PROP_PATH);

    private ECGUtils() {
    }

    public static List<String> LoadECGCurvesMetadata(boolean onlyNames) {
        String prefix = ecgProp.getProperty("ecg.root.path");
        String metadataPath = ecgProp.getProperty(ECG_CURVES_PROP);

        List<String> metadata = new ArrayList<>();
        String line;

        try (BufferedReader br = new BufferedReader(new FileReader(prefix + metadataPath))) {
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                if (onlyNames) {
                    String[] parseLine = line.split(",", 2);
                    String name = parseLine[0].replaceAll("\"", "");
                    metadata.add(name);
                } else {
                    metadata.add(line);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return metadata;
    }

    public static List<Pair<String, List<float[][]>>>  loadECGData() {
        List<Pair<String, List<float[][]>>> ecgCurves = new ArrayList<>();

        List<String> ecgMetadata = LoadECGCurvesMetadata(false);
        for (final String line : ecgMetadata) {
            final String[] ecgFiles = line.split(",");

            String name = ecgFiles[0].replaceAll("\"", "");
            if (ecgFiles.length == 1) {
                ecgCurves.add(new Pair<>(name, null));
            } else {
                List<float[][]> data = new ArrayList<>();

                for (int i = 1; i < ecgFiles.length; i++) {
                    final String[] ecgParse = ecgFiles[i].split(":");

                    try {
                        String prefix = ecgProp.getProperty("ecg.root.path");
                        data.add(loadECGCurve(Integer.valueOf(ecgParse[1]), prefix + ecgParse[0]));
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                ecgCurves.add(new Pair<>(name, data));
            }


        }

        return ecgCurves;
    }

    private static float[][] loadECGCurve(int lineNumber, String pathCurve) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(pathCurve));
        float[][] ecgData = new float[lineNumber - 2][3];

        int numberOfLine = 0;

        br.readLine();
        br.readLine();

        while ((line = br.readLine()) != null) {
            String[] parser = line.split(",");

            ecgData[numberOfLine][0] = Float.valueOf(parser[0]);
            ecgData[numberOfLine][1] = Float.valueOf(parser[1]);
            ecgData[numberOfLine][2] = Float.valueOf(parser[2]);

            numberOfLine++;
        }

        br.close();

        return ecgData;
    }

}
