package data;

import java.io.*;
import java.util.Properties;

public class Utils {
    public static final String SETTINGS_PROP_PATH = "data/configures/connection.properties";
    public static final String GENERAL_PROP_PATH = "data/configures/general.properties";
    public static final String PORT_PROP = "port";
    public static final String MONITOR_NAME_PROP = "monitorName";
    public static final String GENERAL_LANG = "language";
    public static final String MONITOR_IP_ADDRESS = "localhost";

    private Utils() {
    }

    public static Properties loadProperties(String propPath) {
        Properties properties = new Properties();

        try (InputStream inputStream = new FileInputStream(propPath)) {
            properties.load(inputStream);
        } catch (FileNotFoundException exNotFound) {
            System.err.println("Properties: " + propPath + " was not found!");
        } catch (IOException ex) {
            System.err.println("Error while loading: " + propPath);
        }

        return properties;
    }

    public static void saveProperties(Properties properties, String propFilePath) {
        File file = new File(propFilePath);
        try (OutputStream out = new FileOutputStream(file)) {
            properties.store(out, "This is an optional header comment string");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateProperties(String propName, String propValue, String propFilePath) {
        Properties properties = loadProperties(propFilePath);
        if (propValue != null) {
            properties.setProperty(propName, propValue);
            saveProperties(properties, propFilePath);
        }
    }

    public static Object deepCopy(Object object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream outputStrm = new ObjectOutputStream(outputStream);
            outputStrm.writeObject(object);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objInputStream = new ObjectInputStream(inputStream);
            return objInputStream.readObject();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
