package gui_components;

import java.util.ResourceBundle;

import javafx.geometry.Insets;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.TextAlignment;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

/**
 * Created by BobrZlosyn on 14.08.2016.
 */
public class CreateAboutPanel {
	private final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
    private final String monitorText = langResource.getString(KeysForLanguage.COMMON_ABOUT_MONITOR);

    private final String remoterText = langResource.getString(KeysForLanguage.COMMON_ABOUT_REMOTER);

    private final String remoterTitle = langResource.getString(KeysForLanguage.COMMON_ABOUT_REMOTER_TITLE);
    private final String monitorTitle = langResource.getString(KeysForLanguage.COMMON_ABOUT_MONITOR_TITLE);

    public CreateAboutPanel(boolean isMonitor) {
        Alert options = new Alert(Alert.AlertType.CONFIRMATION);
        options.setTitle(langResource.getString(KeysForLanguage.COMMON_ABOUT_TITLE));
        options.setHeaderText(" ");

        GridPane pane = new GridPane();

        pane.setPadding(new Insets(15, 35, 0, 25));
        ColumnConstraints content = new ColumnConstraints();
        RowConstraints row1 = new RowConstraints();
        RowConstraints row2 = new RowConstraints(150);
        RowConstraints row3 = new RowConstraints(30);
        RowConstraints row4 = new RowConstraints();
        RowConstraints row5 = new RowConstraints();
        RowConstraints row6 = new RowConstraints();
        pane.getColumnConstraints().addAll(content);
        pane.getRowConstraints().addAll(row1, row2, row3, row4, row5, row6);
        pane.setMaxWidth(500);
        pane.setMinWidth(400);
        Label text, title;

        if (isMonitor) {
            title = new Label(monitorTitle);
            text = new Label(monitorText);
        } else {
            title = new Label(remoterTitle);
            text = new Label(remoterText);
        }

        title.setStyle("-fx-font-weight:bold");
        text.setWrapText(true);
        text.setTextAlignment(TextAlignment.JUSTIFY);
        Label authorTitle = new Label(langResource.getString(KeysForLanguage.COMMON_ABOUT_AUTORS) + ":");
        authorTitle.setStyle("-fx-font-weight:bold");
        Label author1 = new Label("Patrik Patera");
        Label author2 = new Label("Ludek Kanak");
        Label author3 = new Label("Martin Kantorik");

        pane.add(title, 0, 0);
        pane.add(text, 0, 1);
        pane.add(authorTitle, 0, 2);
        pane.add(author1, 0, 3);
        pane.add(author2, 0, 4);
        pane.add(author3, 0, 5);

        options.setGraphic(pane);
        options.showAndWait();
    }
}
