package vital_ecg;

import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.layout.*;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import vital_parser.ECGParser;

public class LineChartSample extends Application {

    @Override
    public void start(Stage stage) {
        //ECGParser.transformData("data\\ecg\\s_NormalSinRhythm.csv", "data\\ecg\\c_NormalSinRhythm3.csv", 0.414f, 0.945f);
       // ECGParser.removeColumnECG("data\\ecg\\c_1AVBlock6.csv", "data\\ecg\\c_1AVBlock.csv", 1);
        ECGData data = new ECGData();

        VBox p = new VBox();

        //p.getChildren().addAll(data.getGraphECG1(), data.getGraphCO2());
        p.getChildren().addAll(data.getGraphECG1());

        Scene scene = new Scene(p, 600, 130, false, SceneAntialiasing.BALANCED);

        try {
            scene.getStylesheets().add((new File("./src/vital_monitor/chart_style.css")).toURI().toURL().toExternalForm());
        } catch (MalformedURLException ex) {
            Logger.getLogger(LineChartSample.class.getName()).log(Level.SEVERE, null, ex);
        }

        stage.setScene(scene);
        stage.show();

        stage.setOnCloseRequest((WindowEvent t) -> {
            data.clear();
        });
    }

    public static void main(String[] args) {
        launch(args);
    }
}
