package vital_monitor;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.scene.media.AudioClip;
import javafx.util.Duration;

/**
 * Created by BobrZlosyn on 24. 4. 2016.
 */
public class PlaySounds {

    /**
     * cesta k souborum se zvuky
     */
    private final static String PATH_TO_SOUNDS = "/PETER_Monitor/vital_monitor/sounds_monitor/";

    /**
     * definovane soubory s jednotlivymi zvuky
     */
    public final static String DO_KPR = "do_kpr.wav";
    public final static String CONNECT_ELECTRODS_TERAPY = "connect_electrods_for_terapy.wav";
    public final static String DONT_GIVE_SHOCK = "dont_give_shock.wav";
    public final static String DONT_TOUCH_PACIENT = "dont_touch_pacient.wav";
    public final static String START_ANALYSE_EKG = "start_analyse_ekg.wav";
    public final static String SHOCK_READY = "shock_ready.wav";
    public final static String SHOCK_GIVEN = "shock_given.wav";
    public final static String NIBP_SOUND = "nibp_sound.wav";
    public final static String GIVE_SHOCK = "give_shock.wav";
    public final static String FREE_ELECTRODS_TERAPY = "free_electrods_for_terapy.wav";
    public final static String FREE_EKG_ELECTROD = "free_ekg_electrod.wav";

    private AudioClip clip, shockReady1, shockReady2;
    private int volume;
    private Timeline shockReadyAnimation;


    public PlaySounds(int volume) {
        this.volume = volume;
    }

    /**
     * prehraje zvuk
     *
     * @param sound zvuk ktery se ma spustit
     */
    public void playSound(String sound) {
        String s = "sounds_monitor/" + sound;
        stopSound();

        try {
            clip = new AudioClip(this.getClass().getResource(s).toExternalForm());
            clip.play(volume);
        } catch (Exception e) {
            System.out.println("Sound does not exist: " + sound);
            e.printStackTrace();
        }
    }

    public void setVolume(int volume) {
        this.volume = volume;
        stopSound();
    }

    /**
     * zastavi probihajici zvuk
     */
    public void stopSound() {
        if (clip != null) {
            clip.stop();
            clip = null;
        }
        stopShockReadyAnimation();
    }

    /**
     * spusti zvuk pro privany vyboj
     */
    public void startShockReadyAnimation() {

        if (shockReadyAnimation == null) {
            shockReadyAnimation = new Timeline(new KeyFrame(Duration.seconds(1.40), e -> playShockReady()));
            shockReadyAnimation.setCycleCount(Animation.INDEFINITE);
            shockReadyAnimation.play();
        }
    }

    /**
     * aktivni metoda pro timeline shockReadyAnimation
     * spousti stridave zvuk pipani
     */
    private void playShockReady() {
        try {
            String sound =  "./sounds_monitor/" + SHOCK_READY;
            if (shockReady1 == null || !shockReady1.isPlaying()) {
                shockReady1 = new AudioClip(this.getClass().getResource(sound).toExternalForm());
                shockReady1.play(volume);
                return;
            }

            if (shockReady2 == null || shockReady1.isPlaying()) {
                shockReady2 = new AudioClip(this.getClass().getResource(sound).toExternalForm());
                shockReady2.play(volume);
                return;
            }
        } catch (Exception e) {
            System.out.println("Sound doesnt exist");
            e.printStackTrace();
        }
    }

    /**
     * zastavi animaci shockReadyAnimation
     */
    public void stopShockReadyAnimation() {
        if (shockReadyAnimation != null) {

            if (shockReady1 != null)
                shockReady1.stop();

            if (shockReady2 != null)
                shockReady2.stop();

            shockReadyAnimation.stop();
            shockReadyAnimation = null;
        }
    }

}
