package vital_monitor;

import data.VitalData;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.*;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import javafx.util.StringConverter;

import java.lang.reflect.Field;
import java.util.Random;

public class VitalLabel extends GridPane {

    public static VitalData vitalData = new VitalData();

    public static boolean hasOscillate = true;

    private static String BOTTOM_LIMIT = "#ff000033";

    private static String UPPER_LIMIT = "#00000033";

    private static Random randNumber = new Random();

    private static double raisingValueMax = 12;
    private static double raisingValueMin = 4;

    private Label minValueLabelFX, maxValueLabelFX;
    private Timeline animationChangeVal;
    private boolean isChangingVal;

    protected Label actualValueLabel = new Label("--");

    protected Pane background;

    private Field vitalField;

    private static final StringConverter<Number> stringConverterInt = new StringConverter<Number>() {
        @Override
        public String toString(Number object) {
            return (object.intValue() + "");
        }

        @Override
        public Number fromString(String string) {
            return Double.valueOf(string);
        }
    };

    public VitalLabel() {
        ColumnConstraints column1 = new ColumnConstraints(50, GridPane.USE_COMPUTED_SIZE, GridPane.USE_COMPUTED_SIZE);
        ColumnConstraints column2 = new ColumnConstraints(100, GridPane.USE_COMPUTED_SIZE, GridPane.USE_COMPUTED_SIZE);
        ColumnConstraints column3 = new ColumnConstraints(30, GridPane.USE_COMPUTED_SIZE, GridPane.USE_COMPUTED_SIZE);
        column1.setHgrow(Priority.SOMETIMES);
        column1.setHgrow(Priority.SOMETIMES);
        column3.setHgrow(Priority.SOMETIMES);
        column3.setHalignment(HPos.RIGHT);
        column2.setHalignment(HPos.CENTER);
        this.getColumnConstraints().addAll(column1, column2, column3);

        RowConstraints row1 = new RowConstraints(10, 30, GridPane.USE_COMPUTED_SIZE);
        RowConstraints row2 = new RowConstraints(10, 30, GridPane.USE_COMPUTED_SIZE);
        RowConstraints row3 = new RowConstraints(10, 30, GridPane.USE_COMPUTED_SIZE);
        row1.setVgrow(Priority.SOMETIMES);
        row2.setVgrow(Priority.SOMETIMES);
        row3.setVgrow(Priority.SOMETIMES);
        this.getRowConstraints().addAll(row1, row2, row3);

        isChangingVal = true;

        prepareLabels();
    }

    public final BooleanProperty typeProperty() {
        if (type == null) {
            type = new SimpleBooleanProperty(this, "type", true);
        }
        return type;
    }

    private BooleanProperty type = new SimpleBooleanProperty(this, "type", true);

    public final void setType(boolean state) {
        type.setValue(state);
    }

    public final boolean getType() {
        return type == null || type.get();
    }


    public final DoubleProperty oscMaxProperty() {
        if (oscMax == null) {
            oscMax = new SimpleDoubleProperty(this, "oscMax", 12.0);
        }
        return oscMax;
    }

    private DoubleProperty oscMax;

    public final void setOscMax(double value) {
        oscMaxProperty().set(value);
    }

    public final double getOscMax() {
        return oscMax == null ? 12.0 : oscMax.doubleValue();
    }

    public final DoubleProperty oscMinProperty() {
        if (oscMin == null) {
            oscMin = new SimpleDoubleProperty(this, "oscMin", 4.0);
        }
        return oscMin;
    }

    private DoubleProperty oscMin;

    public final void setOscMin(double value) {
        oscMinProperty().set(value);
    }

    public final double getOscMin() {
        return oscMin == null ? 2.0 : oscMin.doubleValue();
    }

    public final DoubleProperty maxPossibleValueProperty() {
        if (maxPossibleValue == null) {
            maxPossibleValue = new SimpleDoubleProperty(this, "maxPossibleValue", 0);
        }
        return maxPossibleValue;
    }

    private DoubleProperty maxPossibleValue;

    public final void setMaxPossibleValue(double value) {
        maxPossibleValueProperty().set(value);
    }

    public final double getMaxPossibleValue() {
        return maxPossibleValue == null ? 0.0 : maxPossibleValue.doubleValue();
    }

    public final DoubleProperty minPossibleValueProperty() {
        if (minPossibleValue == null) {
            minPossibleValue = new SimpleDoubleProperty(this, "minPossibleValue", 0.0);
        }
        return minPossibleValue;
    }

    private DoubleProperty minPossibleValue;

    public final void setMinPossibleValue(double value) {
        minPossibleValueProperty().set(value);
    }

    public final double getMinPossibleValue() {
        return minPossibleValue == null ? 0.0 : minPossibleValue.doubleValue();
    }

    public final DoubleProperty minValueLabelProperty() {
        if (minValueLabel == null) {
            minValueLabel = new SimpleDoubleProperty(this, "minValueLabel", 0.0);
        }
        return minValueLabel;
    }

    private DoubleProperty minValueLabel;

    public final void setMinValueLabel(double value) {
        minValueLabelProperty().set(value);
    }

    public final double getMinValueLabel() {
        return minValueLabel == null ? 0.0 : minValueLabel.doubleValue();
    }

    public final DoubleProperty maxValueLabelProperty() {
        if (maxValueLabel == null) {
            maxValueLabel = new SimpleDoubleProperty(this, "maxValueLabel", 0.0);
        }
        return maxValueLabel;
    }

    private DoubleProperty maxValueLabel;

    public final void setMaxValueLabel(double value) {
        maxValueLabelProperty().set(value);
    }

    public final double getMaxValueLabel() {
        return maxValueLabel == null ? 0.0 : maxValueLabel.doubleValue();
    }


    public final StringProperty propNameProperty() {
        if (propName == null) {
            propName = new SimpleStringProperty(this, "propName", "");
        }
        return propName;
    }

    private StringProperty propName;

    public final void setPropName(String value) {
        try {
            vitalField = vitalData.getClass().getDeclaredField(value);
            vitalField.setAccessible(true);

            if (type.get()) {
                ((IntegerProperty) vitalField.get(vitalData)).addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        isChangingVal = true;
                    }
                });
            } else {
                ((DoubleProperty) vitalField.get(vitalData)).addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        isChangingVal = true;
                    }
                });
            }
            animationChangeVal = new Timeline(new KeyFrame(Duration.seconds(2), e -> {
                try {
                    String val;
                    if (getType()) {
                        val = oscillation((IntegerProperty) vitalField.get(vitalData));
                    } else {
                        val = oscillation((DoubleProperty) vitalField.get(vitalData));
                    }

                    Platform.runLater(() -> actualValueLabel.setText(val));
                    checkLimits();
                } catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
            }));

            animationChangeVal.setCycleCount(Animation.INDEFINITE);
            animationChangeVal.playFromStart();
        } catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }

        propNameProperty().setValue(value);
    }

    public final String getPropName() {
        return propName == null ? "" : propName.getValue();
    }


    public final StringProperty nameProperty() {
        if (name == null) {
            name = new SimpleStringProperty(this, "name", "");
        }
        return name;
    }

    private StringProperty name;

    public final void setName(String value) {
        nameProperty().setValue(value);
    }

    public final String getName() {
        return name == null ? "" : name.getValue();
    }

    public final StringProperty unitsProperty() {
        if (units == null) {
            units = new SimpleStringProperty(this, "units", "");
        }
        return units;
    }

    private StringProperty units;

    public final void setUnits(String value) {
        unitsProperty().setValue(value);
    }

    public final String getUnits() {
        return units == null ? "" : units.getValue();
    }

    public final ObjectProperty<Color> colorLabelProperty() {
        if (colorLabel == null) {
            colorLabel = new SimpleObjectProperty<>(this, "colorLabel", Color.BLACK);
        }
        return colorLabel;
    }

    private ObjectProperty<Color> colorLabel = new SimpleObjectProperty<>(Color.BLACK);

    public final void setColorLabel(Color value) {
        colorLabelProperty().setValue(value);
    }

    public final Color getColorLabel() {
        return colorLabel == null ? Color.BLACK : colorLabel.getValue();
    }

    protected void prepareLabels() {
        Label unitsShortcutLabel = new Label("-");
        unitsShortcutLabel.textProperty().bindBidirectional(unitsProperty());

        Label nameShortcutLabel = new Label("-");
        nameShortcutLabel.textProperty().bindBidirectional(nameProperty());

        minValueLabelFX = new Label("---");
        maxValueLabelFX = new Label("---");

        minValueLabelFX.setAlignment(Pos.CENTER);
        maxValueLabelFX.setAlignment(Pos.CENTER);
        minValueLabelFX.setMinWidth(40);
        maxValueLabelFX.setMinWidth(40);

        minValueLabelProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                final String smin = stringConverterInt.toString(newValue);
                Platform.runLater(() -> minValueLabelFX.setText(smin));
            }
        });

        maxValueLabelProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Platform.runLater(() -> maxValueLabelFX.setText(stringConverterInt.toString(newValue)));
            }
        });

      //  minValueLabelFX.textProperty().bindBidirectional(minValueLabelProperty(), stringConverterInt);
      //  maxValueLabelFX.textProperty().bindBidirectional(maxValueLabelProperty(), stringConverterInt);

        unitsShortcutLabel.setPadding(new Insets(0, 0, 0, 10));
        nameShortcutLabel.setPadding(new Insets(0, 0, 0, 10));
        minValueLabelFX.setPadding(new Insets(0, 10, 0, 0));
        maxValueLabelFX.setPadding(new Insets(0, 10, 0, 0));
        actualValueLabel.setAlignment(Pos.CENTER);
        actualValueLabel.setStyle("-fx-font-size:50;");

        unitsShortcutLabel.textFillProperty().bind(colorLabel);
        nameShortcutLabel.textFillProperty().bind(colorLabel);
        minValueLabelFX.textFillProperty().bind(colorLabel);
        maxValueLabelFX.textFillProperty().bind(colorLabel);
        actualValueLabel.textFillProperty().bind(colorLabel);

        background = new Pane();
        setMargin(background, new Insets(0, 1, 0, 1));

        this.add(background, 0, 0, 3, 3);
        this.add(nameShortcutLabel, 0, 0, 1, 1);
        this.add(unitsShortcutLabel, 0, 2, 1, 1);
        this.add(actualValueLabel, 1, 1, 1, 1);
        this.add(minValueLabelFX, 2, 1, 1, 1);
        this.add(maxValueLabelFX, 2, 2, 1, 1);
    }

    protected void setVisibleMinMaxValues(boolean flag) {
        maxValueLabelFX.setVisible(flag);
        minValueLabelFX.setVisible(flag);
    }

    private String oscillation(IntegerProperty value) {
        int oldVal = value.get();
        int newVal;

        if (isChangingVal) {
            newVal = randNumber.nextInt((int) raisingValueMax) + (int) raisingValueMin;
            int actualVal = actualValueLabel.getText().equals("--") ? (int) minPossibleValue.get() :
                    Integer.valueOf(actualValueLabel.getText());
            boolean condNeg = actualVal <= oldVal;
            newVal = condNeg ? actualVal + newVal : actualVal - newVal;
            isChangingVal = !(condNeg && (newVal >= oldVal));
        } else {
            if (hasOscillate) {
                int mid = ((int) getOscMax()) / 2;
                newVal = oldVal - (randNumber.nextInt((int) getOscMax()) - mid);
                newVal = newVal < minPossibleValue.get() ? 0 : newVal;
                newVal = newVal > maxPossibleValue.get() ? maxPossibleValue.intValue() : newVal;
            } else {
                newVal = oldVal;
            }
        }

        return ((oldVal == -1) ? "--" : String.valueOf(newVal));
    }

    private String oscillation(DoubleProperty value) {
        double oldVal = value.get();
        double newVal;

        if (isChangingVal) {
            double randVal = (raisingValueMin + (raisingValueMax - raisingValueMin) * randNumber.nextDouble());
            double actualVal = actualValueLabel.getText().equals("--") ? minPossibleValue.get() :
                    Double.valueOf(actualValueLabel.getText());
            boolean condNeg = actualVal <= oldVal;
            newVal = condNeg ? actualVal + randVal : actualVal - randVal;
            isChangingVal = !(condNeg && (newVal >= oldVal));
        } else {
            newVal = oldVal - (getOscMin() + (getOscMax() - getOscMin()) * randNumber.nextDouble());
            newVal = newVal < minPossibleValue.get() ? 0 : newVal;
            newVal = newVal > maxPossibleValue.get() ? maxPossibleValue.intValue() : newVal;
        }

        newVal = Math.round(newVal * 10) / 10.0;
        return ((oldVal == -1) ? "--" : String.valueOf(newVal));
    }

    private void checkLimits() {
        if (actualValueLabel.getText().isEmpty()) return;
        if (!actualValueLabel.getText().matches("-?\\d+(\\.\\d+)?")){
            background.setStyle("-fx-background-color:transparent;");
            return;
        }

        Number num = getActualValue();

        if (getType()) {
            if (num.intValue() <= getMinValueLabel()) {
                background.setStyle("-fx-background-color: " + BOTTOM_LIMIT + ";");
            } else if (num.intValue() >= getMaxValueLabel()) {
                background.setStyle("-fx-background-color: " + UPPER_LIMIT + ";");
            } else {
                background.setStyle("-fx-background-color:transparent;");
            }
        } else {
            if (num.doubleValue() <= getMinValueLabel()) {
                background.setStyle("-fx-background-color: " + BOTTOM_LIMIT + ";");
            } else if (num.doubleValue() >= getMaxValueLabel()) {
                background.setStyle("-fx-background-color: " + UPPER_LIMIT + ";");
            } else {
                background.setStyle("-fx-background-color:transparent;");
            }
        }
    }

    private Number getActualValue() {
        final String valueTxt = actualValueLabel.getText();
        return (getType() ? Integer.valueOf(valueTxt) : Double.valueOf(valueTxt));
    }


}
