package vital_monitor.settings;

import gui_components.IPaneSetting;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;
import vital_monitor.NIBPVitalLabel;
import vital_monitor.VitalLabel;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/**
 * Created by BobrZlosyn on 14.08.2016.
 */
public class CreateBoundariesPanel implements IPaneSetting {

    private List<TextField> valuesMax, valuesMin;
    private List<ColorPicker> colors;

    private GridPane valuesFromRemoter;
    private GridPane content;
    private static final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
    public CreateBoundariesPanel(GridPane valuesFromRemoter) {
        this.valuesFromRemoter = valuesFromRemoter;
    }

    private GridPane createPanel() {
        content = new GridPane();
        content.setPadding(new Insets(15, 0, 0, 25));
        ColumnConstraints curve = new ColumnConstraints(100, 100, 100);
        ColumnConstraints minimum = new ColumnConstraints(100, 100, 100);
        minimum.setHalignment(HPos.CENTER);
        ColumnConstraints maximum = new ColumnConstraints(100, 100, 100);
        maximum.setHalignment(HPos.CENTER);
        ColumnConstraints color = new ColumnConstraints(100, 100, 100);
        content.getColumnConstraints().addAll(curve, minimum, maximum, color);

        RowConstraints row1 = new RowConstraints(30, 30, 40);
        RowConstraints row2 = new RowConstraints(30, 30, 40);
        RowConstraints row3 = new RowConstraints(30, 30, 40);
        content.getRowConstraints().addAll(row1, row2, row3);

        valuesMax = new ArrayList<>();
        valuesMin = new ArrayList<>();
        colors = new ArrayList<>();
        fillPane(content);

        return content;
    }

    private void fillPane(GridPane pane) {
        Label vitalFunction = new Label(langResource.getString(KeysForLanguage.MONITOR_BOUND_FUNC));
        Label minOfFunction = new Label(langResource.getString(KeysForLanguage.MONITOR_BOUND_MIN));
        Label maxOfFunction = new Label(langResource.getString(KeysForLanguage.MONITOR_BOUND_MAX));
        Label color = new Label(langResource.getString(KeysForLanguage.MONITOR_BOUND_COLOR));
        pane.add(new Label(langResource.getString(KeysForLanguage.MONITOR_BOUND_BOUND_CRITIC)), 0, 0, 4, 1);
        pane.addRow(1, vitalFunction, minOfFunction, maxOfFunction, color);

        int i = 0;
        for (Node node : valuesFromRemoter.getChildren()) {
            if (node instanceof VitalLabel) {
                VitalLabel vital = (VitalLabel) node;

                Label name = new Label(vital.getName());
                ColorPicker colorPicker = new ColorPicker(vital.getColorLabel());
                colors.add(colorPicker);

                TextField tMin = createTextField((int) vital.getMinValueLabel()),
                        tMax = createTextField((int) vital.getMaxValueLabel());
                valuesMin.add(tMin);
                valuesMax.add(tMax);

                if (node instanceof NIBPVitalLabel) {
                    pane.addRow(i + 2, name, new Label(), new Label(), colorPicker);
                } else {
                    pane.addRow(i + 2, name, tMin, tMax, colorPicker);
                }

                i++;
            }
        }
    }

    private TextField createTextField(int defaultValue) {
        TextField textField = new TextField("" + defaultValue);
        textField.setMaxWidth(50);
        textField.setAlignment(Pos.CENTER);
        textField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d*")) {
                Platform.runLater(() -> textField.setText(newValue.replaceAll("[^\\d]", "")));
            }
        });

        return textField;
    }

    private int retriveNumber(TextField textField) {
        if (!textField.getText().matches("-?\\d+(\\.\\d+)?")) {
            return 0;
        }

        return Integer.parseInt(textField.getText());
    }

    @Override
    public String toString() {
        return langResource.getString(KeysForLanguage.MONITOR_BOUND_BOUND);
    }

    @Override
    public GridPane getContent() {
        return createPanel();
    }

    @Override
    public void saveChanges() {
        int i = 0;
        for (Node node : valuesFromRemoter.getChildren()) {
            if (node instanceof VitalLabel) {
                VitalLabel vital = (VitalLabel) node;

                if (!(node instanceof NIBPVitalLabel)) {
                    int minimum = retriveNumber(valuesMin.get(i)),
                            maximum = retriveNumber(valuesMax.get(i));

                    if (minimum > maximum) {
                        minimum ^= maximum;
                        maximum ^= minimum;
                        minimum ^= maximum;
                    }

                    final double min = minimum, max = maximum;

                    vital.setMinValueLabel(min);
                    vital.setMaxValueLabel(max);
                }

                vital.setColorLabel(colors.get(i).getValue());
                i++;
            }
        }
    }
}
