package vital_monitor.settings;

import gui_components.IPaneSetting;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

import java.util.Locale;
import java.util.ResourceBundle;

import data.Utils;

public class CreateGeneralPanel implements IPaneSetting {

    private ColorPicker topColor, bottomColor;
    private static final ResourceBundle langResource = LoadFXMLWithResourceBundle.getLangResource();

    private GridPane createGeneralPanel() {
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(15, 0, 0, 25));
        ColumnConstraints name = new ColumnConstraints(200);
        ColumnConstraints setting = new ColumnConstraints(200);
        RowConstraints row1 = new RowConstraints();
        RowConstraints row2 = new RowConstraints(40);
        RowConstraints row3 = new RowConstraints(40);
        RowConstraints row4 = new RowConstraints(40);
        pane.getColumnConstraints().addAll(name, setting);
        pane.getRowConstraints().addAll(row1, row2, row3, row4);

        Label title = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL));
        Label label = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL_LANG));

        ComboBox comboBox = new ComboBox(FXCollections.observableArrayList(langResource.getString(KeysForLanguage.MONITOR_GENERAL_CS), langResource.getString(KeysForLanguage.MONITOR_GENERAL_EN)));

        if (Locale.getDefault().getLanguage().equals("cs")) {
            comboBox.getSelectionModel().select(0);
        } else {
            comboBox.getSelectionModel().select(1);
        }

        comboBox.setOnAction(event -> {
            if (comboBox.getSelectionModel().getSelectedIndex() == 0) {
                Locale.setDefault(new Locale("cs"));
                Utils.updateProperties(Utils.GENERAL_LANG, "cs", Utils.GENERAL_PROP_PATH);
            } else {
                Locale.setDefault(new Locale("en"));
                Utils.updateProperties(Utils.GENERAL_LANG, "en", Utils.GENERAL_PROP_PATH);
            }
        });

        Label topLabel = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL_HIGH));
        Label changeLabel = new Label("");
        Label bottomLabel = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL_LOW));
        bottomColor = new ColorPicker(ValuesAboutStateOfApplication.BOTTOMwarning);
        topColor = new ColorPicker(ValuesAboutStateOfApplication.TOPwarning);

        comboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Platform.runLater(() -> {
                    changeLabel.setTextFill(Color.RED);
                    changeLabel.setText(langResource.getString(KeysForLanguage.COMMON_CHANGE_LANG));
                });
            }
        });

        pane.add(title, 0, 0);
        pane.add(changeLabel, 1 , 0);
        pane.add(label, 0, 1);
        pane.add(comboBox, 1, 1);
        pane.add(topLabel, 0, 2);
        pane.add(topColor, 1, 2);
        pane.add(bottomLabel, 0, 3);
        pane.add(bottomColor, 1, 3);

        return pane;
    }

    private void saveGeneralChanges() {
        ValuesAboutStateOfApplication.TOPwarning = topColor.getValue();
        ValuesAboutStateOfApplication.BOTTOMwarning = bottomColor.getValue();
    }

    @Override
    public String toString() {
        return langResource.getString(KeysForLanguage.MONITOR_GENERAL_COLORS);
    }

    @Override
    public void saveChanges() {
        saveGeneralChanges();
    }

    @Override
    public GridPane getContent() {
        return createGeneralPanel();
    }
}
