/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import data.VitalData;

/**
 *
 * @author user
 */
public class Server extends Thread {
	private Socket clientSocket = null;

	private boolean connectionOpen = false;

	
	
	
	private static final Logger LOG = java.util.logging.Logger.getLogger(Server.class.getName());

	private static final int SOCKET_TIMEOUT_CONNECTION = 5000;
	
	public Server() {
	}

	 boolean testConnection() throws ServerConnectionException {
			try {
				DataOutputStream os = null;
				DataInputStream is = null;
				os = new DataOutputStream(clientSocket.getOutputStream());
				os.writeUTF("CLIENT_TEST");
				is = new DataInputStream(clientSocket.getInputStream());
				if (is.readUTF().equals("CLIENT_OK")) {
					LOG.log(Level.INFO, "Connection OK");
					return true;
				}
			} catch (IOException ex) {
				throw new ServerConnectionException(ex);
			}
			return false;
	}
	
	public void waitForDisconnect(int port) {
		try (ServerSocket serverSocket = new ServerSocket(port);){
			LOG.info("Waiting for monitor");
			serverSocket.setSoTimeout(SOCKET_TIMEOUT_CONNECTION);
			clientSocket = serverSocket.accept();
			LOG.info("Monitor connected");
			while (clientSocket != null) {
				testConnection();
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					LOG.log(Level.SEVERE, e.getMessage(), e);
				}
			}	
		} catch (IOException | ServerConnectionException e) {
			LOG.log(Level.FINE, e.getMessage(), e);
			LOG.log(Level.INFO, "Conection was closed.");
		} finally {
			if(clientSocket != null) {
				try {
					clientSocket.close();
				} catch (IOException e) {
					LOG.log(Level.SEVERE,e.getMessage());
				}
			}
		}

	}
	
	public void disconnectMonitor() {
		if(clientSocket != null) {
			try {
				DataOutputStream os = null;
				os = new DataOutputStream(clientSocket.getOutputStream());
				os.writeUTF("SERVER_CLOSE");
				clientSocket.close();
				clientSocket = null;
			} catch (IOException e) {
				LOG.log(Level.SEVERE, e.getMessage(), e);
			}
		}
	}

	public void sendData(VitalData data) {
		DataOutputStream dos = null;
		try {
			dos = new DataOutputStream(clientSocket.getOutputStream());
			dos.writeUTF("DATA");
			ObjectOutputStream oos = new ObjectOutputStream(clientSocket.getOutputStream());
			oos.writeObject(data);
		} catch (IOException ex) {
			LOG.log(Level.SEVERE, null, ex);
		}
	}

	/**
	 * ukonci server
	 */
	public void exitServer() {
		DataOutputStream dos;
		try {
			if (connectionOpen) {
				dos = new DataOutputStream(clientSocket.getOutputStream());
				dos.writeUTF("SERVER_CLOSE");
				dos.close();
				connectionOpen = false;
			}

		} catch (IOException ex) {
			LOG.log(Level.SEVERE, null, ex);

		}
	}
	
	public List<AvailableMonitor> getAvaibleMonitors(int port){
		List<AvailableMonitor> availableMonitors = new ArrayList<>();
		try(DatagramSocket dataSocket = sendSocketToBroadcasts(port)){
			AvailableMonitor avaibleMonitor = null;
			while( (avaibleMonitor  = getAvaibleMonitor(dataSocket)) != null) {
				availableMonitors.add(avaibleMonitor);
			}
			return availableMonitors;
		}
	}
	
	public boolean connectToMonitor(String ipAddress, int port) {
			LOG.info("Connectiong to motinor: "+ ipAddress);
			byte[] sendData = Const.COMMUNICATION_START.getBytes();
			DatagramPacket sendPacket;
			try (DatagramSocket datagramSocket = new DatagramSocket()){
				sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName(ipAddress), port);
				datagramSocket.send(sendPacket);
				LOG.info("Data for monitor connection was send");
				return true;
			} catch (UnknownHostException e) {
				LOG.log(Level.SEVERE, e.getMessage(), e);
			} catch (IOException e) {
				LOG.log(Level.SEVERE, e.getMessage(), e);
			}
			return false;
	}
	
	 /**
     * Pri navazani komunikace vrati adresu serveru
     *
     * @param socket prichozi socket
     * @return
     */
    private AvailableMonitor getAvaibleMonitor(DatagramSocket socket) {
        try {
            byte[] recvBuf = new byte[Const.SIZE_OF_BUFFER];
            DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
            socket.setSoTimeout(Const.TIME_TO_RECIEVE);
            try {
                socket.receive(receivePacket);
            } catch (SocketTimeoutException ex) {
            	LOG.info("Connection time for searching monitor is out. ");
                return null;
            }
            String ipAddress = receivePacket.getAddress().getHostAddress();
            String monitorName = new String(receivePacket.getData());
            LOG.info("Client was found: " + ipAddress);
           
            return new AvailableMonitor(monitorName, ipAddress); 
        } catch (SocketException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
	
	/**
     * Odeslani broadcast socketu
     *
     * @return
     */
    private DatagramSocket sendSocketToBroadcasts(int port) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
                socket.setBroadcast(true);
                byte[] sendData = Const.VERIFICATION_STRING.getBytes();
                try {
                    DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName(Const.DEFAULT_BROADCAST), port);
                    socket.send(sendPacket);
                } catch (Exception e) {
                	LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                Enumeration interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = (NetworkInterface) interfaces.nextElement();
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) {
                        continue;
                    }
                    InetAddress broadcast = null;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        broadcast = interfaceAddress.getBroadcast();
                        if (broadcast == null) {
                            continue;
                        }
                    }
                    try {
                        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, broadcast, port);
                        socket.send(sendPacket);
                    } catch (Exception e) {
                    	continue;
                    }
                }
        } catch (SocketException ex) {
        	LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return socket;
    }

	public void closeServer() {
		if (clientSocket != null) {
			try {
				clientSocket.close();
			} catch (IOException ex) {
				LOG.log(Level.SEVERE, null, ex);
			}
		}
	}

	public boolean isConnectionOpen() {
		return connectionOpen;
	}


	

	

}
