package remoter_GUI;

import data.Utils;
import data.VitalData;
import javafx.application.Platform;
import javafx.beans.property.*;
import javafx.geometry.Insets;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;

import java.lang.reflect.Field;

public class VitalSlider extends StackPane {

    public static VitalData actualVitalData = new VitalData();

    public static DoubleProperty prop = new SimpleDoubleProperty(0.0);

    private final Slider slider;
    private ProgressBar bar = new ProgressBar(0);
    private Field vitalField;

    public VitalSlider() {
        slider = new Slider();
        slider.minProperty().bindBidirectional(minValueSliderProperty());
        slider.maxProperty().bindBidirectional(maxValueSliderProperty());
        slider.valueProperty().bindBidirectional(valueSliderProperty());
        slider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.intValue() <= -1) newValue = slider.getMin();

            final Number valueSlider = newValue;
            Platform.runLater(() -> {
                double doubleVal = (Math.round(valueSlider.doubleValue() * 10.0)) / 10.0;
                labelSlider.get().setText(getType() ? valueSlider.intValue() + "" : doubleVal + "");
            });
        });
        slider.setValue(1.0);

        slider.setRotate(270);
        slider.minWidthProperty().bind(this.heightProperty());
        slider.maxWidthProperty().bind(this.heightProperty());
        slider.setPadding(new Insets(0, 15, 0, 15));

        this.getChildren().addAll(setProgressBar(slider, this.heightProperty()));
        this.getChildren().addAll(slider);
        this.maxWidthProperty().bindBidirectional(prop);
        this.minWidthProperty().bindBidirectional(prop);

        maxValueSlider.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                bar.progressProperty().bind((slider.valueProperty().subtract(slider.getMin())).divide(
                        slider.getMax() - slider.getMin()));
            }
        });
    }

    public final BooleanProperty typeProperty() {
        if (type == null) {
            type = new SimpleBooleanProperty(this, "chboxSlider", true);
        }
        return type;
    }

    private BooleanProperty type = new SimpleBooleanProperty(this, "chboxSlider", true);

    public final void setType(boolean state) {
        type.setValue(state);
    }

    public final boolean getType() {
        return type == null || type.get();
    }

    public final ObjectProperty<CheckBox> chboxSliderProperty() {
        if (chboxSlider == null) {
            chboxSlider = new SimpleObjectProperty<>(this, "chboxSlider", new CheckBox());
        }
        return chboxSlider;
    }

    private ObjectProperty<CheckBox> chboxSlider;

    public final void setChboxSlider(CheckBox chbox) {
        chbox.selectedProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue) {
                    if (type.get()) {
                        slider.valueProperty().bindBidirectional((IntegerProperty) vitalField.get(actualVitalData));
                    } else {
                        slider.valueProperty().bindBidirectional((DoubleProperty) vitalField.get(actualVitalData));
                    }
                } else {
                    if (type.get()) {
                        slider.valueProperty().unbindBidirectional((IntegerProperty) vitalField.get(actualVitalData));
                    } else {
                        slider.valueProperty().unbindBidirectional((DoubleProperty) vitalField.get(actualVitalData));
                    }

                    vitalField = actualVitalData.getClass().getDeclaredField(getName());
                    vitalField.setAccessible(true);

                    if (type.get()) {
                        ((IntegerProperty) vitalField.get(actualVitalData)).set(-1);
                    } else {
                        ((DoubleProperty) vitalField.get(actualVitalData)).set(-1.0);
                    }
                }

            } catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        });
        chboxSliderProperty().setValue(chbox);
    }

    public final CheckBox getChboxSlider() {
        return chboxSlider == null ? new CheckBox() : chboxSlider.get();
    }

    public final ObjectProperty<Label> labelSliderProperty() {
        if (labelSlider == null) {
            labelSlider = new SimpleObjectProperty<>(this, "labelSlider", new Label());
        }
        return labelSlider;
    }

    private ObjectProperty<Label> labelSlider = new SimpleObjectProperty<>(this, "labelSlider", new Label());

    public final void setLabelSlider(Label label) {
        labelSlider.setValue(label);
    }

    public final Label getLabelSlider() {
        return labelSlider == null ? new Label() : labelSlider.get();
    }

    public final DoubleProperty valueSliderProperty() {
        if (valueSlider == null) {
            valueSlider = new SimpleDoubleProperty(this, "valueSlider", 0.0);
        }
        return valueSlider;
    }

    private DoubleProperty valueSlider;

    public final void setValueSlider(double value) {
        valueSliderProperty().set(value);
    }

    public final double getValueSlider() {
        return valueSlider == null ? 0.0 : valueSlider.doubleValue();
    }

    public final DoubleProperty maxValueSliderProperty() {
        if (maxValueSlider == null) {
            maxValueSlider = new SimpleDoubleProperty(this, "maxValueSlider", 0.0);
        }
        return maxValueSlider;
    }

    private DoubleProperty maxValueSlider;

    public final void setMaxValueSlider(double value) {
        maxValueSliderProperty().set(value);
    }

    public final double getMaxValueSlider() {
        return maxValueSlider == null ? 0.0 : maxValueSlider.doubleValue();
    }

    public final DoubleProperty minValueSliderProperty() {
        if (minValueSlider == null) {
            minValueSlider = new SimpleDoubleProperty(this, "minValueSlider", 0.0);
        }
        return minValueSlider;
    }

    private DoubleProperty minValueSlider;

    public final void setMinValueSlider(double value) {
        minValueSliderProperty().set(value);
    }

    public final double getMinValueSlider() {
        return minValueSlider == null ? 0.0 : minValueSlider.doubleValue();
    }

    public final StringProperty nameProperty() {
        if (name == null) {
            name = new SimpleStringProperty(this, "name", "");
        }
        return name;
    }

    private StringProperty name;

    public final void setName(String value) {
        try {
            vitalField = actualVitalData.getClass().getDeclaredField(value);
            vitalField.setAccessible(true);

            if (type.get()) {
                slider.valueProperty().bindBidirectional((IntegerProperty) vitalField.get(actualVitalData));
            } else {
                slider.valueProperty().bindBidirectional((DoubleProperty) vitalField.get(actualVitalData));
            }
        } catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        nameProperty().setValue(value);
    }

    public final String getName() {
        return name == null ? "" : name.getValue();
    }

    private ProgressBar setProgressBar(Slider slider, ReadOnlyDoubleProperty heightProperty) {
        bar.setRotate(270);
        bar.minWidthProperty().bind(heightProperty);
        bar.maxWidthProperty().bind(heightProperty);
        bar.setPadding(new Insets(0, 35, 0, 35));
        bar.progressProperty().bind((slider.valueProperty().subtract(slider.getMin())).divide(
                slider.getMax() - slider.getMin()));

        return bar;
    }

    public static VitalData prepareVitalData() {
        return prepareVitalData(null);
    }

    public static VitalData prepareVitalData(VitalData sendVital) {
        VitalData sendVitalData = sendVital == null ? (VitalData) Utils.deepCopy(actualVitalData) : sendVital;

        if (sendVitalData == null) return null;

        return sendVitalData;
    }

}
