/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Monitor.vital_values.SimpleVitalFunction;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;

public class CreateBoundariesPanel {
    public GridPane createChangeFunctionsBounderiesPanel(Button applyButton) {
        GridPane content = new GridPane();
        content.setPadding(new Insets(15.0, 0.0, 0.0, 25.0));
        ColumnConstraints curve = new ColumnConstraints(100.0, 100.0, 100.0);
        ColumnConstraints minimum = new ColumnConstraints(100.0, 100.0, 100.0);
        minimum.setHalignment(HPos.CENTER);
        ColumnConstraints maximum = new ColumnConstraints(100.0, 100.0, 100.0);
        maximum.setHalignment(HPos.CENTER);
        ColumnConstraints color = new ColumnConstraints(100.0, 100.0, 100.0);
        content.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{curve, minimum, maximum, color});
        RowConstraints row1 = new RowConstraints(30.0, 30.0, 40.0);
        RowConstraints row2 = new RowConstraints(30.0, 30.0, 40.0);
        RowConstraints row3 = new RowConstraints(30.0, 30.0, 40.0);
        content.getRowConstraints().addAll((Object[])new RowConstraints[]{row1, row2, row3});
        this.fillPane(content, applyButton);
        return content;
    }

    private void fillPane(GridPane pane, Button applyButton) {
        Label title = new Label("Nastaven\u00ed kritick\u00fdch mez\u00ed \u017eivnotn\u00edch funkc\u00ed");
        Label vitalFunction = new Label("\u017divotn\u00ed funkce");
        Label minOfFunction = new Label("Minimum");
        Label maxOfFunction = new Label("Maximum");
        Label color = new Label("Barva textu");
        pane.add((Node)title, 0, 0, 4, 1);
        pane.addRow(1, new Node[]{vitalFunction, minOfFunction, maxOfFunction, color});
        int i = 0;
        int j = 0;
        while (i < 6) {
            Label name = new Label(SettingsValues.getNameOfFunctionByIndex(i));
            ColorPicker colorPicker = new ColorPicker(SettingsValues.getColorToVitalFunctionByIndex(i));
            colorPicker.setOnAction(event -> applyButton.setDisable(false));
            if (i == 3) {
                pane.addRow(i + 2, new Node[]{name, new Label(), new Label(), colorPicker});
                j -= 2;
            } else {
                pane.addRow(i + 2, new Node[]{name, this.createTextField(SettingsValues.getBoundaryToVitalFunctionByIndex(j), applyButton), this.createTextField(SettingsValues.getBoundaryToVitalFunctionByIndex(j + 1), applyButton), colorPicker});
            }
            ++i;
            j += 2;
        }
    }

    private TextField createTextField(int defaultValue, Button applyButton) {
        TextField textField = new TextField("" + defaultValue);
        textField.setMaxWidth(40.0);
        textField.setAlignment(Pos.CENTER);
        textField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d*")) {
                textField.setText(newValue.replaceAll("[^\\d]", ""));
            }
            applyButton.setDisable(false);
        });
        return textField;
    }

    private int retriveNumber(TextField textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void saveBoundariesChanges(GridPane pane, ArrayList<SimpleVitalFunction> vitalFunctions) {
        ObservableList children = ((GridPane)pane.getChildren().get(2)).getChildren();
        int i = 5;
        int textfield = 0;
        int color = 0;
        while (i < children.size() - 1) {
            if (i != 17) {
                int maximum;
                int n = ++i;
                TextField min = (TextField)children.get(n);
                int n2 = ++i;
                TextField max = (TextField)children.get(n2);
                ColorPicker colorPicker = (ColorPicker)children.get(++i);
                int minimum = this.retriveNumber(min);
                if (minimum > (maximum = this.retriveNumber(max))) {
                    int pom = minimum;
                    minimum = maximum;
                    maximum = pom;
                }
                SettingsValues.setBoundaryByIndex(textfield++, minimum);
                SettingsValues.setBoundaryByIndex(textfield++, maximum);
                SettingsValues.setColorByIndex(color, (Color)colorPicker.getValue());
                if (vitalFunctions != null) {
                    vitalFunctions.get(color).setColorOfFont((Color)colorPicker.getValue());
                }
            } else {
                ColorPicker colorPicker = (ColorPicker)children.get(i += 3);
                SettingsValues.setColorByIndex(color, (Color)colorPicker.getValue());
            }
            ++i;
            ++color;
        }
    }
}

