/*
 * Decompiled with CFR 0.152.
 */
package PETER_Communications.com_protocol;

import PETER_Communications.com_protocol.ServerConnectionException;
import PETER_Communications.com_protocol.VitalData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server {
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private int port = 55555;
    private boolean connectionOpen = false;
    private boolean closedServer = false;
    private DatagramSocket dataSocket = null;

    public void connectToClient() {
        try {
            this.connectionOpen = true;
            this.findFreePort();
            String string = this.waitForClient();
            if (string == null) {
                return;
            }
            this.connectionOpen = false;
            this.clientSocket = this.serverSocket.accept();
        }
        catch (IOException iOException) {
            System.exit(1);
        }
    }

    public boolean testConnection(boolean bl) throws ServerConnectionException {
        boolean bl2 = bl;
        while (bl == bl2 && !this.closedServer) {
            try {
                Thread.sleep(1000L);
                if (this.clientSocket != null) {
                    DataOutputStream dataOutputStream = null;
                    DataInputStream dataInputStream = null;
                    dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
                    dataOutputStream.writeUTF("CLIENT_TEST");
                    dataInputStream = new DataInputStream(this.clientSocket.getInputStream());
                    if (!dataInputStream.readUTF().equals("CLIENT_OK")) continue;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
            catch (SocketException socketException) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                        this.dataSocket.close();
                        this.serverSocket = null;
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                }
                throw new ServerConnectionException(socketException);
            }
            catch (IOException iOException) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                        this.dataSocket.close();
                        this.serverSocket = null;
                    }
                    catch (IOException iOException2) {
                        Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException2);
                    }
                }
                throw new ServerConnectionException(iOException);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        return bl2;
    }

    private void findFreePort() {
        boolean bl = false;
        while (!bl) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                bl = true;
            }
            catch (IOException iOException) {
                ++this.port;
                if (this.port <= 55560) continue;
                System.exit(1);
            }
        }
    }

    public void sendData(VitalData vitalData) {
        DataOutputStream dataOutputStream = null;
        DataInputStream dataInputStream = null;
        try {
            dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
            dataOutputStream.writeUTF("DATA");
            dataInputStream = new DataInputStream(this.clientSocket.getInputStream());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.clientSocket.getOutputStream());
            objectOutputStream.writeObject(vitalData);
        }
        catch (IOException iOException) {
            Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void exitServer() {
        try {
            if (this.connectionOpen) {
                DataOutputStream dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
                dataOutputStream.writeUTF("SERVER_CLOSE");
                dataOutputStream.close();
                this.connectionOpen = false;
                this.closedServer = true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private String waitForClient() {
        try {
            this.dataSocket = new DatagramSocket(this.port, InetAddress.getByName("0.0.0.0"));
            this.dataSocket.setBroadcast(true);
            byte[] byArray = new byte[1024];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.dataSocket.receive(datagramPacket);
            String string = new String(datagramPacket.getData()).trim();
            if ("CONNECTION_VERIFICATION".equals(string)) {
                byte[] byArray2 = "CONNECTION_VERIFICATION".getBytes();
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length, datagramPacket.getAddress(), datagramPacket.getPort());
                this.dataSocket.send(datagramPacket2);
                return datagramPacket.getAddress().getHostAddress();
            }
        }
        catch (SocketException socketException) {
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void closeServer() {
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        this.closedServer = true;
    }

    public boolean isConnectionOpen() {
        return this.connectionOpen;
    }

    public boolean isClosedServer() {
        return this.closedServer;
    }

    public void setClosedServer(boolean bl) {
        this.closedServer = bl;
    }
}

