/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_ecg;

import PETER_Monitor.vital_ecg.ECGData;
import PETER_Monitor.vital_ecg.ECGPoint;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;

public class ECGAnimation {
    private Runnable animation;
    private ScheduledFuture<?> animateTask;
    private final ECGData ecg;
    private final ScheduledExecutorService executor;
    private double wait;
    private boolean beepSound;

    public ECGAnimation(ScheduledExecutorService scheduledExecutorService, ECGData eCGData) {
        this.ecg = eCGData;
        this.executor = scheduledExecutorService;
        this.beepSound = true;
        this.setAnimation();
    }

    private void setAnimation() {
        this.animation = () -> Platform.runLater(() -> {
            if (!this.ecg.isListEmpty()) {
                ECGPoint eCGPoint = this.ecg.removePoint();
                this.ecg.getGraphECG1().addData(eCGPoint.getPlotting(), eCGPoint.getXValue(), eCGPoint.getECG1YValue());
                this.ecg.decPoint();
                if (this.beepSound) {
                    eCGPoint.beep();
                }
            }
        });
    }

    public ScheduledFuture<?> getAnimation() {
        return this.animateTask;
    }

    public void setBeep(boolean bl) {
        this.beepSound = bl;
    }

    public void setNewAnimation(double d) {
        this.wait = d;
        this.animateTask = this.executor.scheduleAtFixedRate(this.animation, 0L, (long)this.wait, TimeUnit.NANOSECONDS);
    }
}

